/*
 * Decompiled with CFR 0.152.
 */
package com.block.review.controller;

import com.block.review.dto.MyReviewListResponse;
import com.block.review.dto.ReviewRequest;
import com.block.review.service.ReviewService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ReviewController {
    @Autowired
    private ReviewService reviewService;

    @PostMapping(value={"/api/products/{productId}/reviews"})
    public ResponseEntity<Object> createReview(@PathVariable long productId, @RequestBody ReviewRequest reviewRequest) {
        int result = this.reviewService.createReview(productId, reviewRequest);
        if (result == 1 || result == 2) {
            return ResponseEntity.status((int)404).build();
        }
        if (result == 3 || result == 4 || result == 5) {
            return ResponseEntity.status((int)400).build();
        }
        return ResponseEntity.status((int)201).build();
    }

    @PutMapping(value={"/api/reviews/{reviewId}"})
    public ResponseEntity<Object> updateReview(@PathVariable long reviewId, @RequestBody ReviewRequest reviewRequest) {
        int result = this.reviewService.updateReview(reviewId, reviewRequest);
        if (result == 1 || result == 2) {
            return ResponseEntity.status((int)400).build();
        }
        if (result == 3) {
            return ResponseEntity.status((int)404).build();
        }
        return ResponseEntity.status((int)200).build();
    }

    @DeleteMapping(value={"/api/reviews/{reviewId}"})
    public ResponseEntity<Object> deleteReview(@PathVariable long reviewId, @RequestParam long userId) {
        int result = this.reviewService.deleteReview(reviewId, userId);
        if (result == 0) {
            return ResponseEntity.status((int)204).build();
        }
        return ResponseEntity.status((int)404).build();
    }

    @GetMapping(value={"/api/users/{userId}/reviews"})
    public ResponseEntity<MyReviewListResponse> getReviewListByUserId(@PathVariable long userId, @RequestParam(defaultValue="1") int page, @RequestParam(defaultValue="10") int size) {
        MyReviewListResponse myReviewListResponse = this.reviewService.getReviewListByUserId(userId, page, size);
        return ResponseEntity.status((int)200).body((Object)myReviewListResponse);
    }
}

