/*
 * Decompiled with CFR 0.152.
 */
package com.block.review.dao;

import com.block.review.dao.ProductDAO;
import com.block.review.dto.ProductResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class ProductDAO {
    @Autowired
    JdbcTemplate jdbcTemplate;

    public List<ProductResponse> getAllProducts(int page, int size) {
        String sql = "SELECT p.id, p.name, p.description, p.price, p.category, p.stock_quantity, \n\t\tIFNULL( avg(r.rating) , 0  )  as averageRating , \n\t\tcount(r.id) as reviewCount\nfrom products p\nleft join reviews r \non p.id = r.product_id \nGROUP by p.id\norder by p.id \nlimit ? , ? ;";
        int offset = (page - 1) * size;
        return this.jdbcTemplate.query(sql, (RowMapper)new ProductRowMapper(), new Object[]{offset, size});
    }

    public List<ProductResponse> getAllProducts(int page, int size, String category) {
        String sql = "SELECT p.id, p.name, p.description, p.price, p.category, p.stock_quantity ,\n\t\t\tavg(r.rating) as averageRating , \n\t\t\tcount( r.id ) as reviewCount\nfrom products p\nleft join reviews r\non p.id = r.product_id\nwhere category =  ?  \ngroup by p.id\norder by p.id\nlimit ? , ? ;";
        int offset = (page - 1) * size;
        return this.jdbcTemplate.query(sql, (RowMapper)new ProductRowMapper(), new Object[]{category, offset, size});
    }

    public int getTotalElements() {
        String sql = "select count(*)\nfrom products;";
        return (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class);
    }

    public int getTotalElements(String category) {
        String sql = "select count(*)\nfrom products\nwhere category = ? ;";
        return (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class, new Object[]{category});
    }

    public ProductResponse getProductById(long productId) {
        String sql = "select p.id, p.name, p.description, p.price, p.category,p.stock_quantity,\n\t\tIFNULL( avg(r.rating) , 0   )  as averageRating ,  \n\t\tcount(r.id) as reviewCount\nfrom products p\nleft join reviews r \non p.id = r.product_id \nwhere p.id = ? ;";
        return (ProductResponse)this.jdbcTemplate.queryForObject(sql, (RowMapper)new ProductRowMapper(), new Object[]{productId});
    }
}

