/*
 * Decompiled with CFR 0.152.
 */
package com.block.review.dao;

import com.block.review.dao.ReviewDAO;
import com.block.review.dto.MyReviewResponse;
import com.block.review.dto.ReviewRequest;
import com.block.review.dto.ReviewResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class ReviewDAO {
    @Autowired
    JdbcTemplate jdbcTemplate;

    public List<ReviewResponse> getReviewListByProductId(long productId) {
        String sql = "SELECT r.id , r.user_id, u.nickname, r.rating, r.content, r.created_at\nFROM reviews r\njoin users u\non r.user_id = u.id\nwhere product_id =  ?  \norder by r.created_at desc ;";
        return this.jdbcTemplate.query(sql, (RowMapper)new ReviewRowMapper(), new Object[]{productId});
    }

    public int createReview(long productId, ReviewRequest reviewRequest) {
        String sql = "INSERT INTO reviews (product_id, user_id, rating, content)\nvalues ( ? , ?, ? , ? );";
        return this.jdbcTemplate.update(sql, new Object[]{productId, reviewRequest.userId, reviewRequest.rating, reviewRequest.content});
    }

    public int updateReview(long reviewId, ReviewRequest reviewRequest) {
        String sql = "update reviews\nset rating = ? , content = ? \nwhere id = ? and user_id =  ? ;";
        return this.jdbcTemplate.update(sql, new Object[]{reviewRequest.rating, reviewRequest.content, reviewId, reviewRequest.userId});
    }

    public int deleteReview(long reviewId, long userId) {
        String sql = "delete from reviews\nwhere id = ? and user_id = ? ;";
        return this.jdbcTemplate.update(sql, new Object[]{reviewId, userId});
    }

    public List<MyReviewResponse> getReviewListByUserId(long userId, int offset, int size) {
        String sql = "SELECT r.id, r.product_id, p.name as product_name, r.rating, r.content, r.created_at, r.updated_at\nfrom reviews r \njoin products p \non r.product_id = p.id \nwhere user_id =  ? \norder by r.created_at desc\nlimit ? , ? ;";
        return this.jdbcTemplate.query(sql, (RowMapper)new MyReviewRowMapper(), new Object[]{userId, offset, size});
    }

    public int getMyReviewTotalElements(long userId) {
        String sql = "SELECT count(*)\nfrom reviews\nwhere user_id = ? ;";
        return (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class, new Object[]{userId});
    }
}

