/*
 * Decompiled with CFR 0.152.
 */
package com.block.review.service;

import com.block.review.dao.ProductDAO;
import com.block.review.dao.ReviewDAO;
import com.block.review.dto.ProductDetailResponse;
import com.block.review.dto.ProductListResponse;
import com.block.review.dto.ProductResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProductService {
    @Autowired
    ProductDAO productDAO;
    @Autowired
    ReviewDAO reviewDAO;

    public ProductListResponse getAllProducts(int page, int size, String category) {
        if (category == null || category.isEmpty()) {
            List productList = this.productDAO.getAllProducts(page, size);
            int totalElements = this.productDAO.getTotalElements();
            int totalPages = (int)Math.ceil((double)totalElements / (double)size);
            int currentPage = page;
            int pageSize = size;
            ProductListResponse productListResponse = new ProductListResponse(productList, Integer.valueOf(totalPages), Integer.valueOf(totalElements), Integer.valueOf(currentPage), Integer.valueOf(pageSize));
            return productListResponse;
        }
        List productList = this.productDAO.getAllProducts(page, size, category);
        int totalElements = this.productDAO.getTotalElements(category);
        int totalPages = (int)Math.ceil((double)totalElements / (double)size);
        int currentPage = page;
        int pageSize = size;
        ProductListResponse productListResponse = new ProductListResponse(productList, Integer.valueOf(totalPages), Integer.valueOf(totalElements), Integer.valueOf(currentPage), Integer.valueOf(pageSize));
        return productListResponse;
    }

    public ProductDetailResponse getProductById(long productId) {
        ProductResponse product = this.productDAO.getProductById(productId);
        List reviewList = this.reviewDAO.getReviewListByProductId(productId);
        ProductDetailResponse productDetailResponse = new ProductDetailResponse(product, reviewList);
        return productDetailResponse;
    }
}

