/*
 * Decompiled with CFR 0.152.
 */
package com.block.review.service;

import com.block.review.dao.ReviewDAO;
import com.block.review.dto.MyReviewListResponse;
import com.block.review.dto.ReviewRequest;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReviewService {
    @Autowired
    private ReviewDAO reviewDAO;

    public int createReview(long productId, ReviewRequest reviewRequest) {
        if (productId <= 0L) {
            return 1;
        }
        if (reviewRequest.userId <= 0L) {
            return 2;
        }
        if (reviewRequest.rating < 1 || reviewRequest.rating > 5) {
            return 3;
        }
        if (reviewRequest.content == null || reviewRequest.content.length() < 10) {
            return 4;
        }
        try {
            this.reviewDAO.createReview(productId, reviewRequest);
        }
        catch (Exception e) {
            return 5;
        }
        return 0;
    }

    public int updateReview(long reviewId, ReviewRequest reviewRequest) {
        if (reviewRequest.rating < 1 || reviewRequest.rating > 5) {
            return 1;
        }
        if (reviewRequest.content == null || reviewRequest.content.length() < 10) {
            return 2;
        }
        int result = this.reviewDAO.updateReview(reviewId, reviewRequest);
        if (result == 0) {
            return 3;
        }
        return 0;
    }

    public int deleteReview(long reviewId, long userId) {
        int result = this.reviewDAO.deleteReview(reviewId, userId);
        if (result == 1) {
            return 0;
        }
        return 1;
    }

    public MyReviewListResponse getReviewListByUserId(long userId, int page, int size) {
        int offset = (page - 1) * size;
        List myReviewList = this.reviewDAO.getReviewListByUserId(userId, offset, size);
        int totalElements = this.reviewDAO.getMyReviewTotalElements(userId);
        int totalPages = (int)Math.ceil((double)totalElements / (double)size);
        int currentPage = page;
        int pageSize = size;
        MyReviewListResponse myReviewListResponse = new MyReviewListResponse(myReviewList, Integer.valueOf(totalPages), Integer.valueOf(totalElements), Integer.valueOf(currentPage), Integer.valueOf(pageSize));
        return myReviewListResponse;
    }
}

