/*
 * Decompiled with CFR 0.152.
 */
package com.block.food.config;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.security.Keys;
import java.security.Key;
import java.util.Date;
import javax.crypto.SecretKey;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class JwtConfig {
    Key key;
    long tokenValidMilisecond = 5184000000L;

    public JwtConfig(@Value(value="${jwt.secret}") String secretKey) {
        this.key = Keys.hmacShaKeyFor((byte[])secretKey.getBytes());
    }

    public String createToken(Long userId) {
        Date now = new Date();
        Date validity = new Date(now.getTime() + this.tokenValidMilisecond);
        return Jwts.builder().subject(userId.toString()).issuedAt(now).expiration(validity).signWith(this.key, SignatureAlgorithm.HS256).compact();
    }

    public Claims getTokenClaims(String token) {
        return (Claims)Jwts.parser().verifyWith((SecretKey)this.key).build().parseSignedClaims((CharSequence)token).getPayload();
    }
}

