/*
 * Decompiled with CFR 0.152.
 */
package com.block.food.controller;

import com.block.food.dto.RestaurantDetailResponse;
import com.block.food.dto.RestaurantListResponse;
import com.block.food.service.RestaurantService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@CrossOrigin(origins={"*"})
@RestController
public class RestaurantController {
    @Autowired
    RestaurantService restaurantService;

    @GetMapping(value={"/api/v1/restaurants"}, produces={"application/json; charset=UTF-8"})
    public ResponseEntity<RestaurantListResponse> getRestaurants(@RequestParam int page, @RequestParam int size, @RequestParam(required=false) String category, @RequestParam(required=false) String keyword) {
        if (category == null && keyword == null) {
            RestaurantListResponse restaurantListResponse = this.restaurantService.getRestaurants(page, size);
            return ResponseEntity.status((int)200).body((Object)restaurantListResponse);
        }
        if (category != null && keyword == null) {
            RestaurantListResponse restaurantListResponse = this.restaurantService.getRestaurants(page, size, category, null);
            return ResponseEntity.status((int)200).body((Object)restaurantListResponse);
        }
        if (category == null && keyword != null) {
            RestaurantListResponse restaurantListResponse = this.restaurantService.getRestaurants(page, size, null, keyword);
            return ResponseEntity.status((int)200).body((Object)restaurantListResponse);
        }
        RestaurantListResponse restaurantListResponse = this.restaurantService.getRestaurants(page, size, category, keyword);
        return ResponseEntity.status((int)200).body((Object)restaurantListResponse);
    }

    @GetMapping(value={"/api/v1/restaurants/{id}"}, produces={"application/json; charset=UTF-8"})
    public ResponseEntity<RestaurantDetailResponse> getRestaurantDetail(@PathVariable long id) {
        RestaurantDetailResponse restaurantDetailResponse = this.restaurantService.getRestaurantDetail(id);
        return ResponseEntity.status((int)200).body((Object)restaurantDetailResponse);
    }
}

