/*
 * Decompiled with CFR 0.152.
 */
package com.block.food.controller;

import com.block.food.dto.ReviewRequest;
import com.block.food.service.ReviewService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@CrossOrigin(origins={"*"})
@RestController
public class ReviewController {
    @Autowired
    ReviewService reviewService;

    @PostMapping(value={"/api/v1/reviews/restaurant/{restaurantId}/menu/{menuId}"}, produces={"application/json; charset=UTF-8"})
    public ResponseEntity<Void> createReviewPhoto(@RequestHeader(value="Authorization") String token, @PathVariable long restaurantId, @PathVariable long menuId, @RequestParam(value="rating") String rating, @RequestParam(value="content") String content, @RequestParam(value="image", required=false) MultipartFile image) {
        try {
            this.reviewService.createReviewPhoto(token, restaurantId, menuId, rating, content, image);
        }
        catch (Exception e) {
            return ResponseEntity.status((int)400).build();
        }
        return ResponseEntity.status((int)201).build();
    }

    @PostMapping(value={"/api/v1/reviews"}, produces={"application/json; charset=UTF-8"})
    public ResponseEntity<Void> createReview(@RequestHeader(value="Authorization") String token, @RequestBody ReviewRequest reviewRequest) {
        int result = this.reviewService.createReview(token, reviewRequest);
        if (result != 1) {
            return ResponseEntity.status((int)400).build();
        }
        return ResponseEntity.status((int)201).build();
    }
}

