/*
 * Decompiled with CFR 0.152.
 */
package com.block.food.dao;

import com.block.food.dao.RestaurantDAO;
import com.block.food.dto.MenuResponse;
import com.block.food.dto.RestaurantResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class RestaurantDAO {
    @Autowired
    JdbcTemplate jdbcTemplate;

    public List<RestaurantResponse> getRestaurants(int offset, int size) {
        String sql = "SELECT r.id, r.name, r.category, r.address, r.phone, r.description, \n\t\t\tIFNULL(  avg(rv.rating) , 0)  avg_rating   ,\n\t\t\tcount(rv.id)  review_count,\n\t\t\tr.created_at\nfrom restaurant r\nleft join review  rv\non r.id = rv.restaurant_id\ngroup by r.id \norder by r.created_at desc\nlimit ? ,  ?  ;";
        return this.jdbcTemplate.query(sql, (RowMapper)new RestaurantRowMapper(), new Object[]{offset, size});
    }

    public int getTotalElements() {
        String sql = "SELECT count(*)\nfrom restaurant;";
        return (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class);
    }

    public List<RestaurantResponse> getRestaurants(int offset, int size, String category, String keyword) {
        if (category != null && keyword == null) {
            String sql = "SELECT r.id, r.name, r.category, r.address, r.phone, r.description, \n\t\t\tIFNULL(  avg(rv.rating) , 0)  avg_rating   ,\n\t\t\tcount(rv.id)  review_count,\n\t\t\tr.created_at\nfrom restaurant r\nleft join review  rv\non r.id = rv.restaurant_id\nwhere r.category = ? \ngroup by r.id \norder by r.created_at desc\nlimit ? , ? ;";
            return this.jdbcTemplate.query(sql, (RowMapper)new RestaurantRowMapper(), new Object[]{category, offset, size});
        }
        if (category == null && keyword != null) {
            String sql = "SELECT r.id, r.name, r.category, r.address, r.phone, r.description, \n\t\t\tIFNULL(  avg(rv.rating) , 0)  avg_rating   ,\n\t\t\tcount(rv.id)  review_count,\n\t\t\tr.created_at\nfrom restaurant r\nleft join review  rv\non r.id = rv.restaurant_id\nwhere r.name like ? or r.address like ? \ngroup by r.id \norder by r.created_at desc\nlimit ? , ? ;";
            return this.jdbcTemplate.query(sql, (RowMapper)new RestaurantRowMapper(), new Object[]{"%" + keyword + "%", "%" + keyword + "%", offset, size});
        }
        String sql = "SELECT r.id, r.name, r.category, r.address, r.phone, r.description, \n\t\t\tIFNULL(  avg(rv.rating) , 0)  avg_rating   ,\n\t\t\tcount(rv.id)  review_count,\n\t\t\tr.created_at\nfrom restaurant r\nleft join review  rv\non r.id = rv.restaurant_id\nwhere (r.name like ? or r.address like ? ) and category = ? \ngroup by r.id \norder by r.created_at desc\nlimit ? ,  ? ;";
        return this.jdbcTemplate.query(sql, (RowMapper)new RestaurantRowMapper(), new Object[]{"%" + keyword + "%", "%" + keyword + "%", category, offset, size});
    }

    public int getTotalElements(String category, String keyword) {
        if (category != null && keyword == null) {
            String sql = "SELECT count(*)\nfrom restaurant\nwhere category = ? ;";
            return (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class, new Object[]{category});
        }
        if (category == null && keyword != null) {
            String sql = "SELECT count(*)\nfrom restaurant\nwhere name like ? or address like ?;";
            return (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class, new Object[]{"%" + keyword + "%", "%" + keyword + "%"});
        }
        String sql = "SELECT count(*)\nfrom restaurant\nwhere (name like ? or address like ?) and category = ? ;";
        return (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class, new Object[]{"%" + keyword + "%", "%" + keyword + "%", category});
    }

    public RestaurantResponse getRestaurantDetail(long id) {
        String sql = "SELECT r.id, r.name, r.category, r.address, r.phone, r.description, \n\t\t\tIFNULL(  avg(rv.rating) , 0)  avg_rating   ,\n\t\t\tcount(rv.id)  review_count,\n\t\t\tr.created_at\nfrom restaurant r\nleft join review  rv\non r.id = rv.restaurant_id\nwhere r.id = ? \ngroup by r.id;";
        return (RestaurantResponse)this.jdbcTemplate.queryForObject(sql, (RowMapper)new RestaurantRowMapper(), new Object[]{id});
    }

    public List<MenuResponse> getMenuList(long id) {
        String sql = "SELECT m.id, m.name, m.price, m.description, m.category , \n\t\t\tcount( r.id ) reviewCount\nfrom menu m \nleft join review r \non m.id = r.menu_id\nwhere m.restaurant_id =  ?  \ngroup by m.id;";
        return this.jdbcTemplate.query(sql, (RowMapper)new MenuRowMapper(), new Object[]{id});
    }
}

