/*
 * Decompiled with CFR 0.152.
 */
package com.block.food.filter;

import com.block.food.config.JwtConfig;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class JwtAuthenticationFilter
extends OncePerRequestFilter {
    @Autowired
    private JwtConfig jwtConfig;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        try {
            if (request.getRequestURI().equals("/api/v1/users/signup") || request.getRequestURI().equals("/api/v1/users/login") || request.getRequestURI().startsWith("/api/v1/restaurants")) {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                System.out.println("\ud1a0\ud070 \uac80\uc99d \ud1b5\uacfc");
                return;
            }
            String bearerToken = request.getHeader("Authorization");
            if (bearerToken == null || bearerToken.isEmpty() || !bearerToken.startsWith("Bearer ")) {
                System.out.println("\ud1a0\ud070 \uac80\uc99d \uc2e4\ud328");
                response.setStatus(401);
                return;
            }
            String token = bearerToken.substring(7);
            Claims claims = this.jwtConfig.getTokenClaims(token);
            Date expiration = claims.getExpiration();
            if (expiration != null && expiration.before(new Date())) {
                response.setStatus(401);
                return;
            }
            UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)claims.getSubject(), null, null);
            SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (ExpiredJwtException e) {
            response.setStatus(401);
            response.getWriter().write("Token has expired. Please login again.");
            return;
        }
        catch (Exception e) {
            response.setStatus(401);
            response.getWriter().write("Invalid token");
            return;
        }
    }
}

