/*
 * Decompiled with CFR 0.152.
 */
package com.block.food.service;

import com.block.food.dao.RestaurantDAO;
import com.block.food.dto.PageableResponse;
import com.block.food.dto.RestaurantDetailResponse;
import com.block.food.dto.RestaurantListResponse;
import com.block.food.dto.RestaurantResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RestaurantService {
    @Autowired
    RestaurantDAO restaurantDAO;

    public RestaurantListResponse getRestaurants(int page, int size) {
        int offset = (page - 1) * size;
        List restaurantList = this.restaurantDAO.getRestaurants(offset, size);
        int totalElements = this.restaurantDAO.getTotalElements();
        int totalPages = (int)Math.ceil((double)totalElements / (double)size);
        PageableResponse pageableResponse = new PageableResponse(Integer.valueOf(page), Integer.valueOf(size), Integer.valueOf(totalElements), Integer.valueOf(totalPages));
        RestaurantListResponse restaurantListResponse = new RestaurantListResponse(restaurantList, pageableResponse);
        return restaurantListResponse;
    }

    public RestaurantListResponse getRestaurants(int page, int size, String category, String keyword) {
        if (category != null && keyword == null) {
            int offset = (page - 1) * size;
            List restaurantList = this.restaurantDAO.getRestaurants(offset, size, category, null);
            int totalElements = this.restaurantDAO.getTotalElements(category, null);
            int totalPages = (int)Math.ceil((double)totalElements / (double)size);
            PageableResponse pageableResponse = new PageableResponse(Integer.valueOf(page), Integer.valueOf(size), Integer.valueOf(totalElements), Integer.valueOf(totalPages));
            RestaurantListResponse restaurantListResponse = new RestaurantListResponse(restaurantList, pageableResponse);
            return restaurantListResponse;
        }
        if (category == null && keyword != null) {
            int offset = (page - 1) * size;
            List restaurantList = this.restaurantDAO.getRestaurants(offset, size, null, keyword);
            int totalElements = this.restaurantDAO.getTotalElements(null, keyword);
            int totalPages = (int)Math.ceil((double)totalElements / (double)size);
            PageableResponse pageableResponse = new PageableResponse(Integer.valueOf(page), Integer.valueOf(size), Integer.valueOf(totalElements), Integer.valueOf(totalPages));
            RestaurantListResponse restaurantListResponse = new RestaurantListResponse(restaurantList, pageableResponse);
            return restaurantListResponse;
        }
        int offset = (page - 1) * size;
        List restaurantList = this.restaurantDAO.getRestaurants(offset, size, category, keyword);
        int totalElements = this.restaurantDAO.getTotalElements(category, keyword);
        int totalPages = (int)Math.ceil((double)totalElements / (double)size);
        PageableResponse pageableResponse = new PageableResponse(Integer.valueOf(page), Integer.valueOf(size), Integer.valueOf(totalElements), Integer.valueOf(totalPages));
        RestaurantListResponse restaurantListResponse = new RestaurantListResponse(restaurantList, pageableResponse);
        return restaurantListResponse;
    }

    public RestaurantDetailResponse getRestaurantDetail(long id) {
        RestaurantResponse restaurantResponse = this.restaurantDAO.getRestaurantDetail(id);
        List menuList = this.restaurantDAO.getMenuList(id);
        RestaurantDetailResponse restaurantDetailResponse = new RestaurantDetailResponse();
        restaurantDetailResponse.id = restaurantResponse.id;
        restaurantDetailResponse.menus = menuList;
        restaurantDetailResponse.address = restaurantResponse.address;
        restaurantDetailResponse.createdAt = restaurantResponse.createdAt;
        restaurantDetailResponse.avgRating = restaurantResponse.avgRating;
        restaurantDetailResponse.category = restaurantResponse.category;
        restaurantDetailResponse.description = restaurantResponse.description;
        restaurantDetailResponse.name = restaurantResponse.name;
        restaurantDetailResponse.phone = restaurantResponse.phone;
        restaurantDetailResponse.reviewCount = restaurantResponse.reviewCount;
        return restaurantDetailResponse;
    }
}

