/*
 * Decompiled with CFR 0.152.
 */
package com.block.food.service;

import com.block.food.config.JwtConfig;
import com.block.food.dao.ReviewDAO;
import com.block.food.dto.ReviewRequest;
import com.block.food.util.UniqueFileNameGenerator;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.ObjectCannedACL;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;

@Service
public class ReviewService {
    @Autowired
    JwtConfig jwtConfig;
    @Autowired
    ReviewDAO reviewDAO;
    @Value(value="${cloud.aws.s3.bucket}")
    String bucketName;
    @Autowired
    S3Client s3Client;

    public int createReviewPhoto(String token, long restaurantId, long menuId, String rating, String content, MultipartFile image) {
        long userId = Long.parseLong(this.jwtConfig.getTokenClaims(token.substring(7)).getSubject());
        if (image != null) {
            String fileName = UniqueFileNameGenerator.generateUniqueFileName((long)userId, (String)".jpg");
            PutObjectRequest putObjectRequest = (PutObjectRequest)PutObjectRequest.builder().bucket(this.bucketName).key(fileName).contentLength(Long.valueOf(image.getSize())).contentType(image.getContentType()).acl(ObjectCannedACL.PUBLIC_READ).build();
            try {
                this.s3Client.putObject(putObjectRequest, RequestBody.fromInputStream((InputStream)image.getInputStream(), (long)image.getSize()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            String imageUrl = String.format("https://%s.s3.ap-northeast-2.amazonaws.com/%s", this.bucketName, fileName);
            System.out.println("imageUrl = " + imageUrl);
            this.reviewDAO.createReviewPhoto(userId, restaurantId, menuId, rating, content, imageUrl);
            return 0;
        }
        this.reviewDAO.createReviewPhoto(userId, restaurantId, menuId, rating, content);
        return 0;
    }

    public int createReview(String token, ReviewRequest reviewRequest) {
        Long userId = Long.parseLong(this.jwtConfig.getTokenClaims(token.substring(7)).getSubject());
        return this.reviewDAO.createReview(userId.longValue(), reviewRequest);
    }
}

