/*
 * Decompiled with CFR 0.152.
 */
package com.block.food.service;

import com.block.food.config.JwtConfig;
import com.block.food.dao.UserDAO;
import com.block.food.dto.UserRequest;
import com.block.food.entity.User;
import com.block.food.util.EmailValidator;
import com.block.food.util.NicknameValidator;
import com.block.food.util.PasswordValidator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class UserService {
    @Autowired
    PasswordEncoder passwordEncoder;
    @Autowired
    JwtConfig jwtConfig;
    @Autowired
    UserDAO userDAO;

    public int signUp(UserRequest userRequest) {
        if (!EmailValidator.isValidEmail((String)userRequest.email)) {
            return 1;
        }
        if (!PasswordValidator.isValidPassword((String)userRequest.password)) {
            return 2;
        }
        if (!NicknameValidator.isValidInput((String)userRequest.nickname)) {
            return 3;
        }
        System.out.println("UserService  1");
        userRequest.password = this.passwordEncoder.encode((CharSequence)userRequest.password);
        try {
            this.userDAO.signUp(userRequest);
            System.out.println("UserService  2");
        }
        catch (Exception e) {
            System.out.println("UserService  3");
            return 4;
        }
        return 0;
    }

    public Object userLogin(UserRequest userRequest) {
        if (!EmailValidator.isValidEmail((String)userRequest.email)) {
            return 1;
        }
        try {
            User user = this.userDAO.userLogin(userRequest);
            if (!this.passwordEncoder.matches((CharSequence)userRequest.password, user.password)) {
                return 3;
            }
            String token = this.jwtConfig.createToken(user.id);
            return token;
        }
        catch (Exception e) {
            return 2;
        }
    }
}

